/* 
 *  AudioCompressor.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef AUDIO_COMPRESSOR_H
#define AUDIO_COMPRESSOR_H

#include "..\..\Misc\CArray.h"
#include "..\..\AsyncBuffer.h"

#define INTEGER_COMPRESSOR_SIZE 65536
#define COMPRESSOR_BOTTOM       -32767
#define COMPRESSOR_TOP           32768

#define DEFAULT_KNOTS 5
#define DB_RANGE      100
#define COMPRESSOR_STEPS 50
#define DEFAULT_STEP	  5

#define RMS_WINDOW 500

struct TKnot
{
	float in_dBLevel;
	float out_dBLevel;
};


class CAudioCompressor: public CDataSource
{
	public:
		int Compress(char *data, int data_count);
		int CreateCompressor();
		int CreateCompressor(CAsyncBuffer *ibuf);
		int read(char *buffer);
		CAudioCompressor();
		~CAudioCompressor();
		int AdjustKnots(int step);
    void SetProperties(bool bEnabled, int step)
    {
      m_bEnabled = bEnabled;
      if(m_bEnabled)
        AdjustKnots(step);
    }
	private:
		float GetPower(char *data, int data_count);
		float GetOutPowFromInPow(float in_pow);
		int   AdjustPower( char *data, int data_count, float power_gain);
		//int RenderCompressor();

		CArr<TKnot>   knots;

		float past_gain;
		CAsyncBuffer *inbuf;

    bool m_bEnabled;


};


#endif


