/* 
 *  staticinit.cpp
 *
 *  Code from
 *            NekoAmp 1.3 decoder by Avery Lee
 *
 *  FlasKMPEG
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <math.h>
#include <float.h>

#include "AMPDecoder.h"

int AMPDecoder::init_count = 0;

signed char AMPDecoder::group3[31][3];
signed char AMPDecoder::group5[127][3];
signed char AMPDecoder::group9[1023][3];

signed char (*AMPDecoder::group_tbls[3])[3]={
	group3,
	group5,
	group9,
};

extern void init_mdct();

void AMPDecoder::Initialize()
{
	int i,j;
	int v;

	if (init_count)
		return;

	++init_count;

	// initialize IMDCT for layer 3 decoding

	init_mdct();

	// initialize 3/5/9 group decoding tables for layer 2

	for(i=0; i<31; i++) {
		v = i;

		for(j=0; j<3; j++) {
			group3[i][j] = v % 3 - 1;
			v /= 3;
		}
	}

	for(i=0; i<127; i++) {
		v = i;

		for(j=0; j<3; j++) {
			group5[i][j] = v % 5 - 2;
			v /= 5;
		}
	}

	for(i=0; i<1023; i++) {
		v = i;

		for(j=0; j<3; j++) {
			group9[i][j] = v % 9 - 4;
			v /= 9;
		}
	}

}
