/* 
 *  AmpBitstream.h
 *
 *  Code from
 *            NekoAmp 1.3 decoder by Avery Lee
 *
 *  FlasKMPEG
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef f_AMPLIB_BITSTREAM_H
#define f_AMPLIB_BITSTREAM_H

#include "IAMPDecoder.h"

// max layer2 buffer -> 144000 * 384 / 32000 + 1 - 4 = 1725 bytes
// max layer3 buffer -> 144000 * 320 / 32000 + 512 - 4 = 1948 bytes

#define BUFFER_SIZE		(2048)
#define BUFFER_MASK		(BUFFER_SIZE - 1)

class AMPBitstream {
protected:
	IAMPBitsource *pSource;

private:
	unsigned char buf[BUFFER_SIZE];
	int bitcnt;
	int bufpoint;
	int bufindex, bufindexw;
	unsigned long bitheap;

	long _getbits(unsigned char bits);
	long _peekbits(unsigned char bits);
	long _peekbits2(unsigned char bits);

public:

	void resetbits(int bytes);
	void fillbits(int bytes);
	void rewind(int bytes);
	void rewindbits(int bits);
	int tellbits();

	long peekbits(unsigned char bits) {
		if (bitcnt > 24-(int)bits)
			return _peekbits(bits);

		return bitheap >> (32-bits);
	}

	long peekbits2(unsigned char bits) {
		if (bitcnt > 24-(int)bits)
			return _peekbits2(bits);

		return bitheap >> (32-bits);
	}

	void skipbits(unsigned char bits) {
		bitcnt += bits;
		bitheap <<= bits;
	}

	void skipbit() {
		bitcnt++;
		bitheap += bitheap;
	}

	long getbits(unsigned char bits) {
		long rv;
		
		if (!bits)
			return 0;

		if (bitcnt > 24-(int)bits)
			return _getbits(bits);

		rv = bitheap >> (32-bits);

		bitcnt += bits;

		bitheap <<= bits;

		return rv;
	}

	unsigned long getflag() {
		long rv;
		
		if (bitcnt > 23)
			return _getbits(1);

		rv = bitheap;

		++bitcnt;

		bitheap <<= 1;

		return rv&0x80000000;
	}
};

#endif
