/* 
 *  AmpBitstream.cpp
 *
 *  Code from
 *            NekoAmp 1.3 decoder by Avery Lee
 *
 *  FlasKMPEG
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <crtdbg.h>

#include "AMPBitstream.h"

void AMPBitstream::resetbits(int bytes) {
	bufindex = 0;
	bitcnt = 24;
	bitheap = 0;

	if (bytes) {
		bufindexw = bufpoint = pSource->read(buf, bytes);

		if (bufpoint != bytes)
			throw (int)IAMPDecoder::ERR_EOF;
	} else
		bufindexw = bufpoint = 0;
}

void AMPBitstream::fillbits(int bytes) {
	int actual;

	if (bufindexw + bytes > BUFFER_SIZE) {
		actual = pSource->read(buf + bufindexw, BUFFER_SIZE - bufindexw);
		if (actual != BUFFER_SIZE-bufindexw)
			throw (int)IAMPDecoder::ERR_EOF;

		bufindexw = bufindexw+bytes-BUFFER_SIZE;

		actual = pSource->read(buf, bufindexw);

		if (actual != bufindexw)
			throw (int)IAMPDecoder::ERR_EOF;

	} else {
		actual = pSource->read(buf + bufindexw, bytes);

		if (actual != bytes)
			throw (int)IAMPDecoder::ERR_EOF;

		bufindexw += actual;
		if (bufindexw >= BUFFER_SIZE)
			bufindexw -= BUFFER_SIZE;
	}

	bufpoint += bytes;
	if (bufpoint > BUFFER_SIZE)
		bufpoint = BUFFER_SIZE;
}

void AMPBitstream::rewind(int bytes) {
	// restore bytes in buffer

	if (bitcnt <= 16)
		bufpoint += (24-bitcnt)>>3;
//		bufpoint += (24+7-bitcnt)>>3;

//	if (bufpoint < bytes)
//		_RPT2(0,"\t\t\t------Not enough bytes! needed=%d, actual=%d\n", bytes, bufpoint);

	if (bufpoint < bytes)
		throw (int)IAMPDecoder::ERR_INCOMPLETEFRAME;

	bitcnt = 24;
	bitheap = 0;
	bufindex = (bufindexw + BUFFER_SIZE - bytes) & BUFFER_MASK;
	bufpoint = bytes;
}

void AMPBitstream::rewindbits(int bits) {
	long actualbits = tellbits();

	// allow up to 24 bits of oopsie

	if (bits > actualbits+24)
		throw (int)IAMPDecoder::ERR_INCOMPLETEFRAME;

	if (bits == actualbits)
		return;

	if (actualbits > bits && actualbits - bits <= 16)
		getbits(actualbits - bits);
	else {

		bitcnt = 24;
		bitheap = 0;
		bufpoint = ((bits+7)>>3);
		bufindex = (bufindexw + BUFFER_SIZE - bufpoint) & BUFFER_MASK;

		if (bits & 7)
			getbits(8-(bits & 7));
	}
}

int AMPBitstream::tellbits() {
	return bufpoint*8 + (24-bitcnt);
}

long AMPBitstream::_peekbits(unsigned char bits) {
	long rv;

	if (!bits)
		return 0;

	while(bitcnt >= 0 && bufpoint>0) {
		--bufpoint;
		bitheap += ((unsigned long)buf[bufindex++]) << bitcnt;
		bufindex &= BUFFER_MASK;
		bitcnt -= 8;
	}

	if (bitcnt > 24-bits)
		throw (int)IAMPDecoder::ERR_INCOMPLETEFRAME;

	return bitheap >> (32-bits);
}

long AMPBitstream::_peekbits2(unsigned char bits) {
	long rv;

	if (!bits)
		return 0;

	while(bitcnt >= 0 && bufpoint>0) {
		--bufpoint;
		bitheap += ((unsigned long)buf[bufindex++]) << bitcnt;
		bufindex &= BUFFER_MASK;
		bitcnt -= 8;
	}

	return bitheap >> (32-bits);
}

long AMPBitstream::_getbits(unsigned char bits) {
	long rv;

	if (!bits)
		return 0;

	while(bitcnt >= 0 && bufpoint>0) {
		--bufpoint;
		bitheap += ((unsigned long)buf[bufindex++]) << bitcnt;
		bufindex &= BUFFER_MASK;
		bitcnt -= 8;
	}

	if (bitcnt > 24-bits)
		throw (int)IAMPDecoder::ERR_INCOMPLETEFRAME;

	rv = bitheap >> (32-bits);

	bitcnt += bits;

	bitheap <<= bits;

	return rv;
}
