/* 
 *  WaveOutput.cpp 
 *         Original code by Timothy J. Weber.
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include "../FlasKMPEG.h"
#include "../resource.h"
#include "../RunState.h"
#include "WaveOutput.h"

extern TRunState rs;


static double percent;
static int    worker_thread_is_finished;
static int    end_conversion_requested;
static WaveFile *wavFile;
static char pFile[1024];

DWORD WINAPI WorkerThread(LPVOID lpParameter)
{
    unsigned char *data;
    while( rs.audio->GetSamples(0, (short **)&data, (4096*6)>>2) 
        && !end_conversion_requested)
    {
        wavFile->Write( (const char *)data, 4096*6 );
	    percent= ((double)((i64)rs.audio->GetStreamPos() - rs.startFilePos)
                / (double)((i64)rs.audio->GetStreamSize()- rs.startFilePos))*100;
    }
    wavFile->Close();
    worker_thread_is_finished = 1;
    return 0;
}
 


LRESULT CALLBACK DlgExporting(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    static UINT timer;
    HANDLE myThread = NULL;

	switch (message)
	{
        case WM_TIMER:
            if(worker_thread_is_finished)
            {
                CloseHandle( myThread );
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
            }
            else
            {
		    	SendDlgItemMessage( hDlg, IDC_PROGRESS, PBM_SETPOS, (ui32)percent , 0);			
            }
            break;
		case WM_INITDIALOG:
      {
        char szTemp[1024];
        sprintf(szTemp, "Writing audio to %s", pFile);
      
          SetDlgItemText(hDlg, IDC_STATUS,szTemp );
		    	SendDlgItemMessage( hDlg, IDC_PROGRESS, PBM_SETPOS, 0 , 0);	
                worker_thread_is_finished = false;
                end_conversion_requested  = false;
                // Create running thread that will perform the conversio
                DWORD threadID;
                myThread = CreateThread(NULL, 0, WorkerThread, NULL, 0, &threadID);
                if(!myThread)
                   EndDialog(hDlg, LOWORD(wParam));

                timer= SetTimer(hDlg,       // handle of window for timer messages
									    1,          // timer identifier
									    100,        // time-out value
									    NULL        // address of timer procedure
									    );
      }
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
                end_conversion_requested = 1;
				return TRUE;
			}
			break;
	}
    return FALSE;
}
 
void ExportAudio(void)
{
    // Create wave file

    wavFile = new WaveFile();

    if(!rs.audio)
        return;


    strcpy( pFile, rs.prof.audioOutFile );
    strcat( pFile, ".wav" );

	// hrm: check for FreqSameAsInput toggle
	int samplefreq;
	if (rs.prof.sampleFreqSameAsInput)
		samplefreq = rs.audio->sampleRate;
	else
		samplefreq = rs.prof.outSampleFrequency;

    if( wavFile->OpenWrite(pFile) )
    {
       wavFile->SetFormatType(1);                          // Format is PCM
       wavFile->SetNumChannels(2);                         // Stereo
       wavFile->SetBytesPerSample(2);                      // 16 bits
       wavFile->SetBitsPerChannel(16);                     // 16 bits
       wavFile->SetSampleRate(samplefreq); // out sample freq
       wavFile->SetBytesPerSecond( samplefreq * 2 * 2 );

       rs.audio->SetStreamPos(rs.startFilePos);
       
       if( rs.audio->Start( samplefreq, DO_AUDIO, &rs.prof.sAudioProperties, &rs.sAudioTrack) )
            // Now, create modeless dialog box
            DialogBox( rs.hInst, MAKEINTRESOURCE(IDD_EXPORT_AUDIO), rs.hMainWnd, (DLGPROC)DlgExporting );
     }
}
