// AudFrameBuffer.h: interface for the CAudFrameBuffer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AUDFRAMEBUFFER_H__57696342_DFDC_11D3_816D_00000100CF13__INCLUDED_)
#define AFX_AUDFRAMEBUFFER_H__57696342_DFDC_11D3_816D_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "../flasktypes.h"


struct TAudFramePresInfo{
	 i64        PTS;
	bool        hasPTS;
};

class CAudioFrame{

	public:
		CAudioFrame(ui8               *data,
			        ui32               datasize,
                    TAudFramePresInfo *pInfo, 
					CAudioFrame       *next, 
					CAudioFrame       *previous);
		~CAudioFrame();

	ui8                    *data;
	ui32                    datasize;
	ui32					mpeg_layer;
	TAudFramePresInfo       pInfo;
	CAudioFrame            *next;
	CAudioFrame            *previous;
};


class CAudFrameBuffer  
{
public:
  void RemoveAllFrames();
	int RemoveFrame(CAudioFrame *frame);
	int RemoveFirstFrame();
	int AddFrame( ui8 *data, ui32 datasize, TAudFramePresInfo *pinfo );
	CAudFrameBuffer();
	virtual ~CAudFrameBuffer();
	CAudioFrame *firstFrame;
	CAudioFrame  *lastFrame;
	int  n_frames;
};

#endif // !defined(AFX_AUDFRAMEBUFFER_H__57696342_DFDC_11D3_816D_00000100CF13__INCLUDED_)
