/* 
 *  CAC3Dec.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <memory.h>
#include <math.h>
#include "CAC3Dec.h"
extern "C"
{
#include "AC3Dec/ac3.h"
}

//////////////////////////////////////////////////////////////////////
// CAC3Dec Class
//////////////////////////////////////////////////////////////////////

extern "C"
{
extern float m_gainfront;
extern float m_gaincenter;
extern float m_gainrear;

extern int m_dolby_surround;
extern int m_do_normalize;
extern int m_do_multichannelvolume;
}

// Globals
ac3_frame_t *ac3_frame;
ac3_config_t ac3_config;
short        *framedata;
int           datasize;
bool          initialized;

#define FRAME_SIZE 256*6*4

void fill_buffer(unsigned char **start,unsigned char **end)
{
	uint_32 bytes_read;
	*start = (unsigned char *)framedata;
	bytes_read = datasize;
	*end= *start + bytes_read;
}



CAC3Dec::CAC3Dec()
{
  m_gainfront   = 1;
  m_gaincenter  = 1;
  m_gainrear    = 1;
  
  m_dolby_surround = 0;
  m_do_normalize   = 0;
  m_do_multichannelvolume = 0;
	initialized = false;
}

CAC3Dec::~CAC3Dec()
{
	initialized = false;
}

static float CalculateAmp(int nRange, int value )
{
  float dBAmp =  (float)value / 100.0f;
  dBAmp = dBAmp / 20;
  return (float)pow( 10, dBAmp );
}

void CAC3Dec::SetProperties(bool bProLogic, 
                            bool bModifyVolume, 
                            int  nRange, 
                            int  nCenter, 
                            int  nFront, 
                            int  nRear)
{
  m_dolby_surround = bProLogic ? 1 : 0;
  m_do_multichannelvolume = bModifyVolume ? 1 : 0;
  m_gainfront = CalculateAmp( nRange, nFront );
  m_gaincenter= CalculateAmp( nRange, nCenter );
  m_gainrear = CalculateAmp( nRange, nRear );
}

void InitAC3Dec(){
	ac3_config.fill_buffer_callback = fill_buffer;
	ac3_config.num_output_ch = 2;
	ac3_config.flags = 0;

	ac3_init(&ac3_config);
}
int CAC3Dec::Init()
{
	if(!initialized){
		InitAC3Dec();
		initialized = true;
	}
	return 1;
}

int CAC3Dec::End()
{

	return 1;
}


int CAC3Dec::decodeFrame(short *framedata, int datasize, short *buffer)
{
	::framedata= framedata;
    ::datasize = datasize;
	if(ac3_frame=ac3_decode_frame())
		memcpy(buffer, ac3_frame->audio_data, FRAME_SIZE);
	else
		memset(buffer, 0, FRAME_SIZE );

	return FRAME_SIZE;

}
