/* 
 *  AsyncBuffer.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#if !defined(AFX_ASYNCBUFFER_H__3D001224_C393_11D3_94DE_00000100CF13__INCLUDED_)
#define AFX_ASYNCBUFFER_H__3D001224_C393_11D3_94DE_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CDataSource {
public:
	//virtual int read(void *buffer, int bytes)=0;
	virtual int read(char *buffer)=0;
};



class CAsyncBuffer  
{	
	
protected: 
	CDataSource *source;
public:
	CAsyncBuffer(CDataSource *source, int inputLenght, int bufferFillness);
	//CAsyncBuffer(int (*ReadData)(char *), int inputLenght);
	~CAsyncBuffer();
	int ReadBuffer(char **outData, int nItems);
private:
	int bufferFillness;
	int maxInputLength;

	//int (*ReadData)(char *);
	char *Buffer;
	int BufferSize, BufferTop, BufferPtr;
	int inputLenght;
};

#endif // !defined(AFX_ASYNCBUFFER_H__3D001224_C393_11D3_94DE_00000100CF13__INCLUDED_)
